<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>

    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <title lang="en">Výpis Tabulka Směrové prvky</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <h2 lang="en">Výpis Tabulka Směrové prvky</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br />
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>

                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Projekt:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Popis:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@description"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Název souboru:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@file"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Poslední revize:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">&#xa0; </th>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Poznámka:&#xa0; </strong>Všechny jednotky tohoto výpisu jsou 
                                                <xsl:if test="//@linearUnits = 'Imperial'">ve stopách,</xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">v metrech,</xsl:if>
                                                pokud není specifikováno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/><br/>

                                <table border="1" cellpadding="2" cellspacing="0" width="100%">
                                    <thead style="display:table-header-group">
                                        <tr>
                                            <th lang="en" valign="bottom">Prvek</th>
                                            <th lang="en" valign="bottom">Bod<br/>Typ</th>
                                            <th lang="en" valign="bottom">Bod<br/>Číslo</th>
                                            <th lang="en" valign="bottom">Staničení</th>
                                            <th lang="en" valign="bottom">Y<sub>s-jtsk</sub></th>
                                            <th lang="en" valign="bottom">X<sub>s-jtsk</sub></th>
                                            <th lang="en" valign="bottom">Poloměr</th>
                                            <th lang="en" valign="bottom">Délka</th>
                                            <th lang="en" valign="bottom">Delta /<br/>Theta</th>
                                            <th lang="en" valign="bottom">Otočení<br/>Směr</th>
                                            <th lang="en" valign="bottom">K</th>
                                            <th lang="en" valign="bottom">P</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <xsl:for-each select="HorizontalAlignment">
                                            <tr>
                                                <th align="left" colspan="2" lang="en">Název trasy:</th>
                                                <td colspan="10"><xsl:value-of select="@name"/></td>
                                            </tr>
                                            <tr>
                                                <th align="left" colspan="2" lang="en">Popis:</th>
                                                <xsl:choose>
                                                    <xsl:when test="@description">
                                                        <td colspan="10"><xsl:value-of select="@description"/></td>
                                                    </xsl:when>
                                                    <xsl:otherwise><td colspan="10">&#xa0;</td></xsl:otherwise>
                                                </xsl:choose>
                                            </tr>
                                            <tr>
                                                <th align="left" colspan="2" lang="en">Styl:</th>
                                                <td colspan="10"><xsl:value-of select="@style"/></td>
                                            </tr>
                                            <xsl:for-each select="HorizontalElements">
                                                <xsl:apply-templates/>
                                            </xsl:for-each>
                                            <tr><td colspan="12">&#xa0;</td></tr>
                                        </xsl:for-each>
                                    </tbody>
                                </table>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>

    <xsl:template match="HorizontalLine">
        <tr>
            <td align="center" lang="en">Tečna</td>
            <td align="center"><xsl:value-of select="cif:pointType(string(Start/@pointType))"/></td>
            <xsl:choose>
                <xsl:when test="Start/@name">
                    <td align="right"><xsl:value-of select="Start/@name"/></td>
                </xsl:when>
                <xsl:otherwise><td>&#xa0;</td></xsl:otherwise>
            </xsl:choose>
            <td align="right" style="white-space:nowrap">
                <xsl:value-of select="cif:stationFormat(number(Start/station/@externalStation), string(Start/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(Start/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(Start/@northing))"/>
            </td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
        </tr>
        <xsl:if test="StationEquation">
            <xsl:for-each select="StationEquation">
                <tr>
                    <td align="center" lang="en">Vstupní staničení</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(@backStation), string(@backEquation))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(GeometryPoint/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(GeometryPoint/@northing))"/>
                    </td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                </tr>
                <tr>
                    <td align="center" lang="en">Výstupní staničení</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(@aheadStation), string(@aheadEquation))"/>
                    </td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                </tr>
            </xsl:for-each>
        </xsl:if>
        <tr>
            <td align="center" lang="en">Tečna</td>
            <td align="center"><xsl:value-of select="cif:pointType(string(End/@pointType))"/></td>
            <xsl:choose>
                <xsl:when test="End/@name">
                    <td align="right"><xsl:value-of select="End/@name"/></td>
                </xsl:when>
                <xsl:otherwise><td>&#xa0;</td></xsl:otherwise>
            </xsl:choose>
            <td align="right" style="white-space:nowrap">
                <xsl:value-of select="cif:stationFormat(number(End/station/@externalStation), string(End/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(End/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(End/@northing))"/>
            </td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
        </tr>
        <tr/>
    </xsl:template>

    <xsl:template match="HorizontalCircle">
        <tr>
            <td align="center" lang="en">Oblouk</td>
            <td align="center"><xsl:value-of select="cif:pointType(string(Start/@pointType))"/></td>
            <xsl:choose>
                <xsl:when test="Start/@name">
                    <td align="right"><xsl:value-of select="Start/@name"/></td>
                </xsl:when>
                <xsl:otherwise><td>&#xa0;</td></xsl:otherwise>
            </xsl:choose>
            <td align="right" style="white-space:nowrap">
                <xsl:value-of select="cif:stationFormat(number(Start/station/@externalStation), string(Start/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(Start/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(Start/@northing))"/>
            </td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
        </tr>
		<xsl:if test="PI">				
        <tr>
            <td align="center" lang="en">Oblouk</td>
            <td align="center"><xsl:value-of select="cif:pointType(string(PI/@pointType))"/></td>
            <xsl:choose>
                <xsl:when test="PI/@name">
                    <td align="right"><xsl:value-of select="PI/@name"/></td>
                </xsl:when>
                <xsl:otherwise><td>&#xa0;</td></xsl:otherwise>
            </xsl:choose>
            <td align="right" style="white-space:nowrap">
                <xsl:value-of select="cif:stationFormat(number(PI/station/@externalStation), string(PI/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(PI/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(PI/@northing))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@radius))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
            </td>
            <td align="right" style="white-space:nowrag">
                <xsl:value-of select="cif:angularFormat(number(@delta))"/>
            </td>
            <td align="center" lang="en">
                <xsl:if test="@rotationDirection='cw'">Vpravo</xsl:if>
                <xsl:if test="@rotationDirection = 'ccw'">Vlevo</xsl:if>
            </td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
        </tr>
        </xsl:if> 
        <tr>
            <td align="center" lang="en">Oblouk</td>
            <td align="center"><xsl:value-of select="cif:pointType(string(Center/@pointType))"/></td>
            <xsl:choose>
                <xsl:when test="Center/@name">
                    <td align="right"><xsl:value-of select="Center/@name"/></td>
                </xsl:when>
                <xsl:otherwise><td>&#xa0;</td></xsl:otherwise>
            </xsl:choose>
            <td>&#xa0;</td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(Center/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(Center/@northing))"/>
            </td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
        </tr>
        <xsl:if test="StationEquation">
            <xsl:for-each select="StationEquation">
                <tr>
                    <td align="center" lang="en">Vstupní staničení</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(@backStation), string(@backEquation))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(GeometryPoint/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(GeometryPoint/@northing))"/>
                    </td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                </tr>
                <tr>
                    <td align="center" lang="en">Výstupní staničení</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(@aheadStation), string(@aheadEquation))"/>
                    </td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                </tr>
            </xsl:for-each>
        </xsl:if>
        <tr>
            <td align="center" lang="en">Oblouk</td>
            <td align="center"><xsl:value-of select="cif:pointType(string(End/@pointType))"/></td>
            <xsl:choose>
                <xsl:when test="End/@name">
                    <td align="right"><xsl:value-of select="End/@name"/></td>
                </xsl:when>
                <xsl:otherwise><td>&#xa0;</td></xsl:otherwise>
            </xsl:choose>
            <td align="right" style="white-space:nowrap">
                <xsl:value-of select="cif:stationFormat(number(End/station/@externalStation), string(End/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(End/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(End/@northing))"/>
            </td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
        </tr>
        <tr/>
    </xsl:template>

    <xsl:template match="HorizontalSpiral">
        <tr>
            <td align="center" lang="en">
                <xsl:choose>
                    <xsl:when test="@compound = 'false'">
                        <xsl:value-of select="@type"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text> Mezilehlá </xsl:text>
                        <xsl:value-of select="@type"/>
                    </xsl:otherwise>
                </xsl:choose>
            </td>
            <td align="center"><xsl:value-of select="cif:pointType(string(Start/@pointType))"/></td>
            <xsl:choose>
                <xsl:when test="Start/@name">
                    <td align="right"><xsl:value-of select="Start/@name"/></td>
                </xsl:when>
                <xsl:otherwise><td>&#xa0;</td></xsl:otherwise>
            </xsl:choose>
            <td align="right" style="white-space:nowrap">
                <xsl:value-of select="cif:stationFormat(number(Start/station/@externalStation), string(Start/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(Start/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(Start/@northing))"/>
            </td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
        </tr>
        <tr>
            <td align="center" lang="en">
                <xsl:choose>
                    <xsl:when test="@compound = 'false'">
                        <xsl:value-of select="@type"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text> Mezilehlá </xsl:text>
                        <xsl:value-of select="@type"/>
                    </xsl:otherwise>
                </xsl:choose>
            </td>
            <td align="center"><xsl:value-of select="cif:pointType(string(PI/@pointType))"/></td>
            <xsl:choose>
                <xsl:when test="PI/@name">
                    <td align="right"><xsl:value-of select="PI/@name"/></td>
                </xsl:when>
                <xsl:otherwise><td>&#xa0;</td></xsl:otherwise>
            </xsl:choose>
            <td align="right" style="white-space:nowrap">
                <xsl:value-of select="cif:stationFormat(number(PI/station/@externalStation), string(PI/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(PI/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(PI/@northing))"/>
            </td>
            <td>&#xa0;</td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
            </td>
            <td align="right" style="white-space:nowrap">
                <xsl:value-of select="cif:angularFormat(number(@thetaAngle))"/>
            </td>
            <td align="center" lang="en">
                <xsl:if test="@rotationDirection='cw'">Vpravo</xsl:if>
                <xsl:if test="@rotationDirection = 'ccw'">Vlevo</xsl:if>
            </td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@ks))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@p))"/>
            </td>
        </tr>
        <xsl:if test="StationEquation">
            <xsl:for-each select="StationEquation">
                <tr>
                    <td align="center" lang="en">Vstupní staničení</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(@backStation), string(@backEquation))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(GeometryPoint/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(GeometryPoint/@northing))"/>
                    </td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                </tr>
                <tr>
                    <td align="center" lang="en">Výstupní staničení</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(@aheadStation), string(@aheadEquation))"/>
                    </td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                    <td>&#xa0;</td>
                </tr>
            </xsl:for-each>
        </xsl:if>
        <tr>
            <td align="center" lang="en">
                <xsl:choose>
                    <xsl:when test="@compound = 'false'">
                        <xsl:value-of select="@type"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text> Mezilehlá </xsl:text>
                        <xsl:value-of select="@type"/>
                    </xsl:otherwise>
                </xsl:choose>
            </td>
            <td align="center"><xsl:value-of select="cif:pointType(string(End/@pointType))"/></td>
            <xsl:choose>
                <xsl:when test="End/@name">
                    <td align="right"><xsl:value-of select="End/@name"/></td>
                </xsl:when>
                <xsl:otherwise><td>&#xa0;</td></xsl:otherwise>
            </xsl:choose>
            <td align="right" style="white-space:nowrap">
                <xsl:value-of select="cif:stationFormat(number(End/station/@externalStation), string(End/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(End/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(End/@northing))"/>
            </td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
            <td>&#xa0;</td>
        </tr>
        <tr/>
    </xsl:template>

    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
              Pro tento výpis musíte vybrat nejméně jeden Civil směrový prvek.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2012 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
